import logging
import HTMLParser
import Queue
import urllib

class ParseImages(HTMLParser.HTMLParser):

	__url = "http://www.repubblica.it"
	__html_data = ""
	__queue = None
	__verbose = False

	@property
	def url(self):
		"""URL da scandire"""
		return self.__url

	@url.setter
	def url(self, url_str):
		self.__url = url_obj

	@property
	def html_data(self):
		"""Contenuto HTML della pagina Web"""
		return self.__html_data

	@html_data.setter
	def html_data(self, html_data_str):
		self.__html_data = html_data__str

	@property
	def queue(self):
		"""Coda di comunicazione"""
		return self.__queue

	@queue.setter
	def queue(self, queue_obj):
		self.__queue = queue_obj

	@property
	def verbose(self):
		"""Output verboso"""
		return self.__verbose

	@verbose.setter
	def verbose(self, verbose_flag):
		self.__verbose = verbose_flag


	def __init__(self, url = "http://www.repubblica.it", queue = queue, \
		verbose = verbose):

		self.url = url
		self.queue = queue
		self.verbose = verbose

		HTMLParser.HTMLParser.__init__(self) 
		if self.verbose == True:
			logging.info("Fetching HTML code for URL %s" % self.url)
		u = urllib.urlopen(url)
		self.html_data = u.read()

	def handle_starttag(self, tag, attrs):
		if tag == 'img':
			for name,value in attrs:
				#print "name = ", name, "value = ", value		
				if name == 'src':
					if self.verbose == True:
						logging.info("Adding img URL %s" %value)
						if value.startswith('/'):
							value = self.url + value
						self.queue.put(value)

	def parse(self):
		if self.verbose == True:
			logging.info("Parsing HTML")
		self.feed(self.html_data)
