import threading
import time

class Producer(threading.Thread):

	__queue = None
	__finished = False

	@property
	def queue(self):
		"""Coda per la comunicazione con la GUI (oggetto Queue)."""
		return self.__queue

	@queue.setter
	def queue(self, queue_obj):
		self.__queue = queue_obj

	@property
	def finished(self):
		"""Flag indicazione fine operazioni"""
		return self.__finished

	@finished.setter
	def finished(self, finished_flag):
		self.__finished = finished_flag

	def __init__(self, group=None, target=None, name=None, \
		args=(), verbose=None):
		threading.Thread.__init__(self, group=group, target=target, name=name, \
			verbose=verbose)
		(self.queue,) = args
		self.finished = False

		return

	def run(self):
		while self.finished == False:
			self.queue.put("Messaggio di prova")
			time.sleep(1)
		return
